#include <iostream>
#include <cmath>
#include <algorithm>
#include <list>

struct vektor {
    int x, y, index;
    float ugao;
};

bool sortiranje(vektor a, vektor b) {
    if (a.ugao==b.ugao) return a.index<b.index;
    return a.ugao<b.ugao;
}

int main()
{
    int n;
    vektor arr[2000000];
    scanf("%d", &n);
    for (int i=0; i<n; i++) {
        scanf("%d", &arr[i].x);
        scanf("%d", &arr[i].y);
        arr[i].index=i;
        arr[i].ugao = std::atan2(arr[i].y, arr[i].x) * 180 / M_PI;
        if (arr[i].ugao < 0) arr[i].ugao += 360;
    }
    std::sort(arr, arr+n, sortiranje);
    for (int i=0; i<n; i++) {
        arr[n+i] = arr[i];
        arr[n+i].ugao += 360;
    }
    
    float max=0;
    int l=0;
    float max_len=0;
    int rez_l=0, rez_r=0;
    int x_zbir=0, y_zbir=0;
    
    for (int r=0; r<2*n; r++) {
        x_zbir += arr[r].x;
        y_zbir += arr[r].y;
        
        while (arr[r].ugao - arr[l].ugao > 180) {
            x_zbir -= arr[l].x;
            y_zbir -= arr[l].y;
            l++;
        }
        
        if (r-l+1 <= n && sqrt(x_zbir*x_zbir + y_zbir*y_zbir) > max_len) {
            max_len = sqrt(x_zbir*x_zbir + y_zbir*y_zbir);
            rez_l = l;
            rez_r = r;
        }
    }
    
    printf("%d\n", rez_r-rez_l+1);
    for (int i=rez_l; i<=rez_r; i++) printf("%d ", arr[i].index+1);
    
    return 0;
}